
#include "Emu6502.h"

void T6502Emulation::reset()
{
  /* Setup registers: */
  state.A = state.X = state.Y = 0;
  state.P = 0x30;
  state.S = 0xff;

  /* Set PPC to pointer at $FFFC: */
  state.PPC = (unsigned short) (readMemory (0xfffc) + (readMemory (0xfffd) << 8));
}

#define  SHORTOPCODES  22
#define  BENCHOPCODES  33

const byte benchopcode[BENCHOPCODES] = {0x06,0x16,0x24,0x45,0x48,0x65,0x68,0x76,
                                  0x84,0x85,0x86,0x91,0x94,0xA4,0xA5,0xA6,
                                  0xB1,0xB4,0xC0,0xC4,0xC5,0xE6,
                                  0x19,0x6D,0x8D,0x99,0x9D,0xAD,0xB9,0xBD,
                                  0xDD,0xED,0xEE};

void T6502Emulation::setupBenchmark () 
{
	state.A = state.X = state.Y = 0;
	state.PPC = 0x300;
	state.S = 0xFF;

  // CREATE CODE SEGMENTS CONSISTING OF GROUPS OF COMMONLY-USED OPCODES
  {
    int addr   = 0x300;
    int opcode = 0;
    do {
      *(mem+addr++) = benchopcode[opcode];
      *(mem+addr++) = benchopcode[opcode];
      if (opcode >= SHORTOPCODES)
        *(mem+addr++) = 0;
      if ((++opcode >= BENCHOPCODES) || ((addr & 0x0F) >= 0x0B)) {
        *(mem+addr++) = 0x4C;
        *(mem+addr++) = (opcode >= BENCHOPCODES) ? 0x00
                                                 : ((addr >> 4)+1) << 4;
        *(mem+addr++) = 0x03;
        while (addr & 0x0F)
          ++addr;
      }
    } while (opcode < BENCHOPCODES);
  }
}


extern "C" {

	int read6502(void* context, int x)
	{
		return ((T6502Emulation*)context)->readMemory(x);
	}
	void write6502(void* context, int x, int y)
	{
		((T6502Emulation*)context)->writeMemory(x,y);
	}
	
	void execute6502(T6502State* state, 
					void* context,
					int totalcycles);

}

void T6502Emulation::execute(int totalcycles)
{
	state.mem = mem;
	execute6502(&state, (void*)this, totalcycles);
}

